
try {
	var colorcircle = new Object;

	colorcircle.setForeground = function (color)
	{
		app.foregroundColor = colorcircle.translateColor(color);
		app.bringToFront();
	}

	colorcircle.setBackground = function (color)
	{
		app.backgroundColor = colorcircle.translateColor(color);
		app.bringToFront();
	}

	colorcircle.getForeground = function ()
	{
		xml = "<object>";
		xml += colorcircle.convertToXML(app.foregroundColor.rgb.hexValue.toString(), "foreground");
		xml += "</object>"
		return xml;
	}

	colorcircle.getBackground = function (){
		xml = "<object>";
		xml += colorcircle.convertToXML(app.backgroundColor.rgb.hexValue.toString(), "background");
		xml += "</object>"
		return xml;
	}

	colorcircle.translateColor = function (c){
		var color = new SolidColor;
		color.rgb.red 	= (c >> 16) & 0xFF;
		color.rgb.green = (c >> 8) & 0xFF;
		color.rgb.blue 	= c & 0xFF;
		return color;
	}


	colorcircle.convertToXML = function (property, identifier){
		var type = typeof property;
		var xml = '<property id = "' + identifier + '" >';
		
		switch(type){
			case "number":
				xml += "<number>";
				xml += property.toString();
				xml += "</number>";
				break;
			case "boolean":
				xml += "<" + property.toString() + "/>";
				break;
			case "string":
				xml += "<string>";
				xml += property.toString();
				xml += "</string>";
				break;
			case "object":
				// Object case is currently not supported
				alert("Object case is currently not supported");
				//xml += "<object>";
				//for(var i in property)
				//	xml += convertToXML(property[i], 
				//xml += "</object>";
				break;
			case "undefined":
				xml += "<string>undefined</string>";
				break;
			default:
				alert("Type " + type + " is unknown.");
				return "";
		}
		xml += '</property>';
		return xml;
	}

	colorcircle.getVersion = function () {
		xml = "<object>";
		xml += colorcircle.convertToXML(app.version, "version");
		xml += "</object>"
		return xml;
	}

}
catch(e) {
	alert("colorcircle error: " + e + " : " + e.line);
}